<?php

declare(strict_types=1);

namespace Skyboard\Interfaces\Http\Controllers;

use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;
use Skyboard\Infrastructure\Persistence\DatabaseConnection;

final class DevAdminController
{
    public function __construct(
        private readonly DatabaseConnection $connection,
        private readonly string $environment
    ) {
    }

    public function elevate(Request $request): Response
    {
        if ($this->environment === 'prod') {
            return Response::error('FORBIDDEN_ENV', 'Admin elevation is disabled in production.', [], 403);
        }

        $user = $request->getAttribute('user');
        if (!$user) {
            return Response::error('UNAUTHENTICATED', 'Authentification requise.', [], 401);
        }

        $userId = (int) ($user['id'] ?? 0);
        if ($userId <= 0) {
            return Response::error('INVALID_USER', 'Utilisateur invalide.', [], 422);
        }

        $pdo = $this->connection->pdo();

        $insert = $pdo->prepare(
            'INSERT IGNORE INTO user_profiles(user_id, pseudo, role) VALUES(:id, :pseudo, :role)'
        );
        $insert->execute([
            'id' => $userId,
            'pseudo' => 'utilisateur',
            'role' => 'standard',
        ]);

        $update = $pdo->prepare('UPDATE user_profiles SET role = :role WHERE user_id = :id');
        $update->execute([
            'role' => 'admin',
            'id' => $userId,
        ]);

        return Response::ok([
            'userId' => $userId,
            'role' => 'admin',
        ]);
    }
}
