#!/usr/bin/env bash
set -euo pipefail

cd "$(git rev-parse --show-toplevel)"

missing=$(grep -L -m1 -E '^> ⚠️ \*\*MODE DEV STRICT' docs/*.md || true)
if [ -n "$missing" ]; then
  echo "[CI] Docs sans bannière DEV STRICT :"
  echo "$missing" | tr ' ' '\n'
  exit 1
fi

echo "[CI] Bannière DEV STRICT OK."
