<?php

declare(strict_types=1);

// Script de reset DEV: supprime toutes les lignes des tables sensibles
// Usage: php tools/reset_dev_db.php "mysql:host=127.0.0.1;port=3306;dbname=skyboard;charset=utf8mb4" user pass

use PDO;
use Throwable;

if ($argc < 2) {
    fwrite(STDERR, "Usage: php tools/reset_dev_db.php <dsn> [user] [password]\n");
    exit(1);
}

$dsn = (string)$argv[1];
$username = $argv[2] ?? '';
$password = $argv[3] ?? '';

try {
    $pdo = new PDO(
        $dsn,
        $username === '' ? null : $username,
        $password === '' ? null : $password,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
    $driver = $pdo->getAttribute(PDO::ATTR_DRIVER_NAME);
    $tables = [
        // V4 rich notifications & subscriptions
        'notification_user_state',
        'notifications_rich',
        'user_subscriptions',
        'scheduler_meta',
        'notification_categories',
        'license_links',
        'user_licenses',
        'licenses',
        'board_rules',
        'boards',
        'sessions',
        'ip_rec',
        'user_file_folders',
        'user_files',
        'user_profiles',
        'users',
    ];

    if ($driver !== 'mysql') {
        fwrite(STDERR, "RESET_UNSUPPORTED_DRIVER: " . $driver . "\n");
        exit(2);
    }

    $pdo->exec('SET FOREIGN_KEY_CHECKS=0');
    foreach ($tables as $table) {
        $pdo->exec('TRUNCATE TABLE `' . $table . '`');
    }
    $pdo->exec('SET FOREIGN_KEY_CHECKS=1');
    echo "OK: database reset (MySQL).\n";
    exit(0);
} catch (Throwable $e) {
    if (isset($pdo) && $pdo->inTransaction()) {
        $pdo->rollBack();
    }
    fwrite(STDERR, "RESET_FAILED: " . $e->getMessage() . "\n");
    exit(3);
}
