#!/usr/bin/env bash
set -euo pipefail
BASE_URL="${BASE_URL:-http://localhost}"

test_json_error () {
  path="$1"; data="$2"; expect="$3"
  http=$(curl -s -o /dev/stderr -w "%{http_code}" -H 'Content-Type: application/json' \
    -H "X-CSRF-Token: test" -X POST "$BASE_URL$path" -d "$data") || true
  echo "[$path] http=$http"
}

# Bus direct
test_json_error "/api/commands" '{"type":"Unknown.Command","payload":{}}' 422

# Compat: quelques endpoints REST connus
test_json_error "/api/boards" '{"title":""}' 422

exit 0

